% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__string.R
\name{ExprStr_strptime}
\alias{ExprStr_strptime}
\title{Parse a Date or DateTime Series}
\arguments{
\item{datatype}{a temporal data type either pl$Date, pl$Time or pl$Datetime}

\item{fmt}{fmt string for parsing see
see details here https://docs.rs/chrono/latest/chrono/format/strftime/index.html#fn6
Notice time_zone \%Z is not supported and will just ignore timezones. Numeric tz  like
\%z, \%:z  .... are supported.}

\item{strict}{bool, if true raise error if a single string cannot be parsed, else produce a
polars \code{null}.}

\item{exact}{bool , If True, require an exact format match. If False, allow the format to match
anywhere in the target string.}

\item{cache}{Use a cache of unique, converted dates to apply the datetime conversion.}
}
\value{
Expr of a Data, Datetime or Time Series
}
\description{
Parse a Series of dtype Utf8 to a Date/Datetime Series.
}
\details{
Notes When parsing a Datetime the column precision will be inferred from the format
string, if given, eg: “\%F \%T\%.3f” => Datetime(“ms”). If no fractional second component is found
then the default is “us”.
}
\examples{
s = pl$Series(
  c(
    "2021-04-22",
    "2022-01-04 00:00:00",
    "01/31/22",
    "Sun Jul  8 00:34:60 2001"
  ),
  "date"
)
#' #join multiple passes with different fmt
s$to_frame()$with_columns(
  pl$col("date")
  $str$strptime(pl$Date, "\%F", strict = FALSE)
  $fill_null(pl$col("date")$str$strptime(pl$Date, "\%F \%T", strict = FALSE))
  $fill_null(pl$col("date")$str$strptime(pl$Date, "\%D", strict = FALSE))
  $fill_null(pl$col("date")$str$strptime(pl$Date, "\%c", strict = FALSE))
)

txt_datetimes = c(
  "2023-01-01 11:22:33 -0100",
  "2023-01-01 11:22:33 +0300",
  "invalid time"
)

pl$lit(txt_datetimes)$str$strptime(
  pl$Datetime("ns"),
  fmt = "\%Y-\%m-\%d \%H:\%M:\%S \%z", strict = FALSE,
)$lit_to_s()
}
\keyword{ExprStr}
