% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__string.R
\name{ExprStr_encode}
\alias{ExprStr_encode}
\alias{expr_str_encode}
\title{encode}
\arguments{
\item{encoding}{string choice either 'hex' or 'base64'}
}
\value{
Utf8 array with values encoded using provided encoding
}
\description{
Encode a value using the provided encoding.
}
\examples{
df = pl$DataFrame(strings = c("foo", "bar", NA))
df$select(pl$col("strings")$str$encode("hex"))
df$with_columns(
  pl$col("strings")$str$encode("base64")$alias("base64"), # notice DataType is not encoded
  pl$col("strings")$str$encode("hex")$alias("hex") # ... and must restored with cast
)$with_columns(
  pl$col("base64")$str$decode("base64")$alias("base64_decoded")$cast(pl$Utf8),
  pl$col("hex")$str$decode("hex")$alias("hex_decoded")$cast(pl$Utf8)
)
}
\keyword{ExprStr}
