% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_metadata.R
\name{fix_metadata}
\alias{fix_metadata}
\alias{fix_metadata.data.frame}
\title{Fix metadata in a PO object}
\usage{
fix_metadata(x, pkg = ".", ...)

\method{fix_metadata}{data.frame}(x, pkg = ".", file_type, ...)
}
\arguments{
\item{x}{An object of class \code{po}, or the data frame from the
\code{metadata} element of such an object.}

\item{pkg}{A path to the root of an R package source directory, or a
\code{package} object, as created by \code{\link[devtools]{as.package}}.}

\item{...}{Arguments passed between methods.}

\item{file_type}{A string giving the file type; either "po" or "pot".}
}
\value{
An object of the same type as the input, but with the metadata fixed.
}
\description{
Fixes the metadata in a \code{po} object, as generated by
\code{\link{read_po}}.
}
\details{
Columns are added to ensure that the metadata data frame contains
character columns named "name" and "value". Likewise rows are added or
updated as follows.
\describe{
\item{Project-Id-Version}{The package name and version, taken from the
"Package" and "Version" fields of the DESCRIPTION file specified in the
\code{pkg} argument.}
\item{Report-Msgid-Bugs-To}{The URL to report bugs to, taken from the
"BugReports" field of the DESCRIPTION file specified in the \code{pkg}
argument.}
\item{POT-Creation-Date}{Not auto-updated.}
\item{PO-Revision-Date}{The current date and time, in format
"%Y-%m-%d %H:%M:%S%z". See \code{\link[base]{strptime}} for details of date
and time formatting specifications.}
\item{Last-Translator}{Not auto-updated.}
\item{Language-Team}{Not auto-updated.}
\item{MIME-Version}{Always changed to "1.0".}
\item{Content-Type}{Always changed to "text/plain; charset=UTF-8".}
\item{Content-Transfer-Encoding}{Always changed to "8bit".}
}
Additionally PO, but not POT, files have these rows:
\describe{
\item{Language}{An ISO 639-1 two-letter language code.  See \url{http://www.loc.gov/standards/iso639-2/php/code_list.php}}
\item{Plural-Forms}{The plural-form specification for the Language code.}
}
}
\examples{
pot_file <- system.file("extdata/R-summerof69.pot", package = "poio")
pot <- read_po(pot_file)
pot_fixed <- fix_metadata(pot, system.file(package = "poio"))

# Compare the metadata before and after
pot$metadata
pot_fixed$metadata
}

