% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emailing.R
\name{email_blast}
\alias{email_blast}
\title{Send email at a step or at the end of an interrogation}
\usage{
email_blast(
  x,
  to,
  from,
  credentials = NULL,
  msg_subject = NULL,
  msg_header = NULL,
  msg_body = stock_msg_body(),
  msg_footer = stock_msg_footer(),
  send_condition = ~TRUE \%in\% x$notify
)
}
\arguments{
\item{x}{A reference to list object prepared by the agent. It's only
available in an internal evaluation context.}

\item{to, from}{The email addresses for the recipients and the sender.}

\item{credentials}{A credentials list object that is produced by either of
the \code{\link[blastula:credential_helpers]{blastula::creds()}}, \code{\link[blastula:credential_helpers]{blastula::creds_anonymous()}},
\code{\link[blastula:credential_helpers]{blastula::creds_key()}}, or \code{\link[blastula:credential_helpers]{blastula::creds_file()}} functions. Please
refer to the \strong{blastula} documentation for details on each of these helper
functions.}

\item{msg_subject}{The subject line of the email message.}

\item{msg_header, msg_body, msg_footer}{Content for the header, body, and
footer components of the HTML email message.}

\item{send_condition}{An expression that should evaluate to a logical vector
of length 1. If \code{TRUE} then the email will be sent, if \code{FALSE} then that
won't happen. The expression can use x-list variables (e.g., \code{x$notify},
\code{x$type}, etc.) and all of those variables can be viewed using the
\code{\link[=get_agent_x_list]{get_agent_x_list()}} function. The default expression is \code{~TRUE \%in\% x$notify},
which results in \code{TRUE} if there are any \code{TRUE} values in the \code{x$notify}
logical vector (i.e., any validation step results in a 'notify'
condition).}
}
\description{
The \code{email_blast()} function is useful for sending an email message that
explains the result of a \strong{pointblank} validation. It is powered by the
\strong{blastula} and \strong{glue} packages. This function should be invoked as part
of the \code{end_fns} argument of \code{\link[=create_agent]{create_agent()}}. It's also possible to invoke
\code{email_blast()} as part of the \code{fns} argument of the \code{\link[=action_levels]{action_levels()}}
function (to possibly send an email message at one or more steps).
}
\details{
To better get a handle on emailing with \code{email_blast()}, the analogous
\code{\link[=email_preview]{email_preview()}} can be used with a \strong{pointblank} agent object or the
output obtained from using the \code{\link[=get_agent_x_list]{get_agent_x_list()}} function.
}
\section{Function ID}{

3-1
}

\examples{
# Create a simple table with two
# columns of numerical values
tbl <-
  dplyr::tibble(
    a = c(5, 7, 6, 5, 8, 7),
    b = c(7, 1, 0, 0, 0, 3)
  )

# Create an `action_levels()` list
# with absolute values for the
# `warn`, and `notify` states (with
# thresholds of 1 and 2 'fail' units)
al <- 
  action_levels(
    warn_at = 1,
    notify_at = 2
  )

# Validate that values in column
# `a` from `tbl` are always > 5 and
# that `b` values are always < 5;
# first, apply the `actions_levels()`
# directive to `actions` and set up
# an `email_blast()` as one of the
# `end_fns` (by default, the email
# will be sent if there is a single
# 'notify' state across all
# validation steps)
# agent <-
#   create_agent(
#     tbl = tbl,
#     actions = al,
#     end_fns = list(
#       ~ email_blast(
#         x,
#         to = "joe_public@example.com",
#         from = "pb_notif@example.com",
#         msg_subject = "Table Validation",
#         credentials = blastula::creds_key(
#           id = "gmail"
#         ),
#       )
#     )
#   ) \%>\%
#   col_vals_gt(vars(a), 5) \%>\%
#   col_vals_lt(vars(b), 5) \%>\%
#   interrogate()

# This example was intentionally
# not run because email credentials
# aren't available and the `to`
# and `from` email addresses are
# nonexistent; to look at the email
# message before sending anything of
# the like, we can use the 
# `email_preview()` function
email_object <-
  create_agent(
    tbl = tbl,
    actions = al
  ) \%>\%
  col_vals_gt(vars(a), 5) \%>\%
  col_vals_lt(vars(b), 5) \%>\%
  interrogate() \%>\%
  email_preview()
  
}
\seealso{
Other Emailing: 
\code{\link{email_preview}()},
\code{\link{stock_msg_body}()},
\code{\link{stock_msg_footer}()}
}
\concept{Emailing}
