% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_row_sample_info.R
\name{get_row_sample_info}
\alias{get_row_sample_info}
\title{Get information on sample rows from non-passing validations}
\usage{
get_row_sample_info(agent)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}. It should have had
\code{\link[=interrogate]{interrogate()}} called on it, such that the validation steps were carried
out and any sample rows from non-passing validations could potentially be
available in the object.}
}
\description{
Get information on which validation steps produced sample rows from
non-passing validations.
}
\examples{
\dontrun{
# Set a seed
set.seed(23)

# Create a simple data frame with a
# column of numerical values
df <-
  data.frame(
    a = rnorm(
      n = 100,
      mean = 5,
      sd = 2))

# Create 2 simple validation steps
# that test whether values within
# column `a`
agent <-
  create_agent() \%>\%
  focus_on(tbl_name = "df") \%>\%
  col_vals_between(
    column = a,
    left = 4,
    right = 6) \%>\%
  col_vals_lte(
    column = a,
    value = 10) \%>\%
  interrogate(
    get_problem_rows = TRUE,
    get_first_n = 10)
  
# Find out which validation steps
# contain sample row data
get_row_sample_info(agent)
}

}
