% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agent_report.R
\name{get_agent_report}
\alias{get_agent_report}
\title{Get a summary report from an agent}
\usage{
get_agent_report(
  agent,
  arrange_by = c("i", "severity"),
  keep = c("all", "fail_states"),
  display_table = TRUE,
  size = "standard",
  title = ":default:",
  lang = NULL,
  locale = NULL
)
}
\arguments{
\item{agent}{\emph{The pointblank agent object}

\verb{obj:<ptblank_agent>} // \strong{required}

A \strong{pointblank} \emph{agent} object that is commonly created through the use of
the \code{\link[=create_agent]{create_agent()}} function.}

\item{arrange_by}{\emph{Method of arranging the report's table rows}

\verb{singl-kw:[i|severity]} // \emph{default:} \code{"i"}

A choice to arrange the report table rows by the validation step number
(\code{"i"}, the default), or, to arrange in descending order by severity of the
failure state (with \code{"severity"}).}

\item{keep}{\emph{Which table rows should be kept?}

\verb{singl-kw:[all|fail_states]} // \emph{default:} \code{"all"}

An option to keep \code{"all"} of the report's table rows (the
default), or, keep only those rows that reflect one or more
\code{"fail_states"}.}

\item{display_table}{\emph{Return a display-table report via gt}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Should a display table be generated? If \code{TRUE}, and if the \strong{gt} package
is installed, a display table for the report will be shown in the Viewer.
If \code{FALSE}, or if \strong{gt} is not available, then a tibble will be returned.}

\item{size}{\emph{Size option for display-table report}

\verb{scalar<character>} // \emph{default:} \code{"standard"}

The size of the display table, which can be either \code{"standard"} (the
default) or \code{"small"}. This only applies to a display table (where
\code{display_table = TRUE}).}

\item{title}{\emph{Title customization options}

\verb{scalar<character>} // \emph{default:} \code{":default:"}

Options for customizing the title of the report. The default is the keyword
\code{":default:"} which produces generic title text that refers to the
\strong{pointblank} package in the language governed by the \code{lang} option.
Another keyword option is \code{":tbl_name:"}, and that presents the name of the
table as the title for the report. If no title is wanted, then the
\code{":none:"} keyword option can be used. Aside from keyword options, text can
be provided for the title and \code{glue::glue()} calls can be used to construct
the text string. If providing text, it will be interpreted as Markdown text
and transformed internally to HTML. To circumvent such a transformation,
use text in \code{\link[=I]{I()}} to explicitly state that the supplied text should not be
transformed.}

\item{lang}{\emph{Reporting language}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The language to use for automatic creation of briefs (short descriptions
for each validation step) and for the \emph{agent report} (a summary table that
provides the validation plan and the results from the interrogation. By
default, \code{NULL} will create English (\code{"en"}) text. Other options include
French (\code{"fr"}), German (\code{"de"}), Italian (\code{"it"}), Spanish (\code{"es"}),
Portuguese (\code{"pt"}), Turkish (\code{"tr"}), Chinese (\code{"zh"}), Russian (\code{"ru"}),
Polish (\code{"pl"}), Danish (\code{"da"}), Swedish (\code{"sv"}), and Dutch (\code{"nl"}).
This \code{lang} option will override any previously set language setting (e.g.,
by the \code{\link[=create_agent]{create_agent()}} call).}

\item{locale}{\emph{Locale for value formatting}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale ID to use for formatting values in the
\emph{agent report} summary table according the locale's rules. Examples include
\code{"en_US"} for English (United States) and \code{"fr_FR"} for French (France);
more simply, this can be a language identifier without a country
designation, like \code{"es"} for Spanish (Spain, same as \code{"es_ES"}). This
\code{locale} option will override any previously set locale value (e.g., by the
\code{\link[=create_agent]{create_agent()}} call).}
}
\value{
A \code{ptblank_agent_report} object if \code{display_table = TRUE} or a tibble
if \code{display_table = FALSE}.
}
\description{
We can get an informative summary table from an agent by using the
\code{get_agent_report()} function. The table can be provided in two substantially
different forms: as a \strong{gt} based display table (the default), or, as a
tibble. The amount of fields with intel is different depending on whether or
not the agent performed an interrogation (with the \code{\link[=interrogate]{interrogate()}} function).
Basically, before \code{\link[=interrogate]{interrogate()}} is called, the agent will contain just the
validation plan (however many rows it has depends on how many validation
functions were supplied a part of that plan). Post-interrogation, information
on the passing and failing test units is provided, along with indicators on
whether certain failure states were entered (provided they were set through
\code{actions}). The display table variant of the agent report, the default form,
will have the following columns:

\itemize{
\item i (unlabeled): the validation step number.
\item STEP: the name of the validation function used for the validation step,
\item COLUMNS: the names of the target columns used in the validation step
(if applicable).
\item VALUES: the values used in the validation step, where applicable; this
could be as literal values, as column names, an expression, etc.
\item TBL: indicates whether any there were any changes to the target table
just prior to interrogation. A rightward arrow from a small circle indicates
that there was no mutation of the table. An arrow from a circle to a purple
square indicates that preconditions were used to modify the target table. An
arrow from a circle to a half-filled circle indicates that the target table
has been segmented.
\item EVAL: a symbol that denotes the success of interrogation evaluation
for each step. A checkmark indicates no issues with evaluation. A warning
sign indicates that a warning occurred during evaluation. An explosion symbol
indicates that evaluation failed due to an error. Hover over the symbol for
details on each condition.
\item UNITS: the total number of test units for the validation step
\item PASS: on top is the absolute number of \emph{passing} test units and below
that is the fraction of \emph{passing} test units over the total number of test
units.
\item FAIL: on top is the absolute number of \emph{failing} test units and below
that is the fraction of \emph{failing} test units over the total number of test
units.
\item W, S, N: indicators that show whether the \code{warn}, \code{stop}, or \code{notify}
states were entered; unset states appear as dashes, states that are set with
thresholds appear as unfilled circles when not entered and filled when
thresholds are exceeded (colors for W, S, and N are amber, red, and blue)
\item EXT: a column that provides buttons to download data extracts as CSV
files for row-based validation steps having \strong{failing} test units. Buttons
only appear when there is data to collect.
}

The small version of the display table (obtained using \code{size = "small"})
omits the \code{COLUMNS}, \code{TBL}, and \code{EXT} columns. The width of the small table
is 575px; the standard table is 875px wide.

The \code{ptblank_agent_report} can be exported to a standalone HTML document
with the \code{\link[=export_report]{export_report()}} function.

If choosing to get a tibble (with \code{display_table = FALSE}), it will have the
following columns:

\itemize{
\item i: the validation step number.
\item type: the name of the validation function used for the validation step.
\item columns: the names of the target columns used in the validation step
(if applicable).
\item values: the values used in the validation step, where applicable; for
a \code{\link[=conjointly]{conjointly()}} validation step, this is a listing of all sub-validations.
\item precon: indicates whether any there are any preconditions to apply
before interrogation and, if so, the number of statements used.
\item active: a logical value that indicates whether a validation step is
set to \code{"active"} during an interrogation.
\item eval: a character value that denotes the success of interrogation
evaluation for each step. A value of \code{"OK"} indicates no issues with
evaluation. The \code{"WARNING"} value indicates a warning occurred during
evaluation. The \code{"ERROR"} VALUES indicates that evaluation failed due to an
error. With \code{"W+E"} both warnings and an error occurred during evaluation.
\item units: the total number of test units for the validation step.
\item n_pass: the number of \emph{passing} test units.
\item f_pass: the fraction of \emph{passing} test units.
\item W, S, N: logical value stating whether the \code{warn}, \code{stop}, or \code{notify}
states were entered. Will be \code{NA} for states that are unset.
\item extract: an integer value that indicates the number of rows available
in a data extract. Will be \code{NA} if no extract is available.
}
}
\section{Examples}{


For the example here, we'll use a simple table with a single numerical column
\code{a}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <- dplyr::tibble(a = c(5, 7, 8, 5))

tbl
#> # A tibble: 4 x 1
#>       a
#>   <dbl>
#> 1     5
#> 2     7
#> 3     8
#> 4     5
}\if{html}{\out{</div>}}

Let's create an \emph{agent} and validate that values in column \code{a} are always
greater than \code{4}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <-
  create_agent(
    tbl = tbl,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\%
  col_vals_gt(columns = a, value = 4) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

We can get a tibble-based report from the agent by using \code{get_agent_report()}
with \code{display_table = FALSE}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent \%>\% get_agent_report(display_table = FALSE)
}\if{html}{\out{</div>}}

\preformatted{## # A tibble: 1 × 14
##       i type    columns values precon active eval  units n_pass
##   <int> <chr>   <chr>   <chr>  <chr>  <lgl>  <chr> <dbl>  <dbl>
## 1     1 col_va… a       4      NA     TRUE   OK        4      4
## # … with 5 more variables: f_pass <dbl>, W <lgl>, S <lgl>,
## #   N <lgl>, extract <int>}



The full-featured display-table-based report can be viewed by printing the
\code{agent} object, but, we can get a \code{"ptblank_agent_report"} object returned to
us when using \code{display_table = TRUE} (the default for \code{get_agent_report}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{report <- get_agent_report(agent)

report
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_get_agent_report_1.png" alt="This image was generated from the first code example in the `get_agent_report()` help file." style="width:100\%;">
}
}

What can you do with the \code{report} object? Print it at will wherever, and, it
can serve as an input to the \code{\link[=export_report]{export_report()}} function.

However, the better reason to use \code{get_agent_report()} over just printing the
agent for display-table purposes is to make use of the different display
options.

The agent report as a \strong{gt} display table comes in two sizes: \code{"standard"}
(the default, 875px wide) and \code{"small"} (575px wide). Let's take a look at
the smaller-sized version of the report.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{small_report <- 
  get_agent_report(
    agent = agent,
    size = "small"
  )
  
small_report
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_get_agent_report_2.png" alt="This image was generated from the second code example in the `get_agent_report()` help file." style="width:100\%;">
}
}

We can use our own title by supplying it to the \code{title} argument, or, use
a special keyword like \code{":tbl_name:"} to get the table name (set in the
\code{\link[=create_agent]{create_agent()}} call) as the title.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{report_title <- get_agent_report(agent, title = ":tbl_name:")

report_title
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_get_agent_report_3.png" alt="This image was generated from the third code example in the `get_agent_report()` help file." style="width:100\%;">
}
}

There are more options! You can change the language of the display table with
the \code{lang} argument (this overrides the language set in \code{\link[=create_agent]{create_agent()}}),
validation steps can be rearranged using the \code{arrange_by} argument, and we
can also apply some filtering with the \code{keep} argument in
\code{get_agent_report()}.
}

\section{Function ID}{

6-2
}

\seealso{
Other Interrogate and Report: 
\code{\link{interrogate}()}
}
\concept{Interrogate and Report}
