% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_read_informant.R
\name{yaml_read_informant}
\alias{yaml_read_informant}
\title{Read a \strong{pointblank} YAML file to create an \emph{informant} object}
\usage{
yaml_read_informant(filename, path = NULL)
}
\arguments{
\item{filename}{The name of the YAML file that contains fields related to an
\emph{informant}.}

\item{path}{An optional path to the YAML file (combined with \code{filename}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
With \code{yaml_read_informant()} we can read a \strong{pointblank} YAML file that
describes table information (typically generated by the \code{\link[=yaml_write]{yaml_write()}}
function. What's returned is a new \emph{informant} object with the information
intact. The \emph{informant} object can be given more information through use of
the \verb{info_*()} functions.
}
\section{Examples}{


There's a YAML file available in the \strong{pointblank} package that's called
\code{"informant-small_table.yml"}. The path for it can be accessed through
\code{system.file()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yml_file_path <- 
  system.file(
    "yaml", "informant-small_table.yml",
    package = "pointblank"
  )
}\if{html}{\out{</div>}}

The YAML file can be read as an informant by using the
\code{yaml_read_informant()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <- yaml_read_informant(filename = yml_file_path)

informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_yaml_write_3.png" alt="This image was generated from the third code example in the `yaml_write()` help file." style="width:100\%;">
}
}

As can be seen from the information report, the available table metadata was
restored and reported. If you expect metadata to change with time, it might
be beneficial to use \code{\link[=incorporate]{incorporate()}} to query the target table. Or, we can
perform this querying directly from the YAML file with
\code{\link[=yaml_informant_incorporate]{yaml_informant_incorporate()}}.
}

\section{Function ID}{

11-3
}

\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
