% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_clean_names}
\alias{utils_clean_names}
\title{Clean entries name records}
\usage{
utils_clean_names(directory)
}
\arguments{
\item{directory}{A directory dataframe.}
}
\value{
A dataframe.
}
\description{
Clean name columns (forename & surname) of provided directory dataframe.
}
\examples{
\dontrun{
  directory <- data.frame(
    page = c("71", "71"),
    surname = c("ABOT", "ABRCROMBIE"), forename = c("Wm.", "Alex"),
    occupation = c("Wine and spirit merchant", "Baker"),
    address.number = c(" -; 1820", ",,12"),
    address.body = c(
      "London st. ; house, Mary hill.*",
      "&;Dixon st.; residence, Craigrownie, Cove.$"
    ),
    stringsAsFactors = FALSE
  )
  utils_clean_names(directory)
}
}
