% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_3cmt.R
\name{calc_ss_3cmt}
\alias{calc_ss_3cmt}
\alias{calc_ss_3cmt_linear_bolus}
\alias{calc_ss_3cmt_linear_oral_1_lag}
\alias{calc_ss_3cmt_linear_infusion}
\alias{calc_ss_3cmt_linear_oral_0}
\alias{calc_ss_3cmt_linear_oral_0_lag}
\alias{calc_ss_3cmt_linear_oral_1}
\title{Calculate C(t) for a 3-compartment linear model at steady-state}
\usage{
calc_ss_3cmt(tad, tau, dose, dur = NULL, tinf = NULL, ...)

calc_ss_3cmt_linear_bolus(tad, tau, dose, ...)

calc_ss_3cmt_linear_oral_1_lag(tad, tau, dose, ...)

calc_ss_3cmt_linear_infusion(tad, tau, dose, tinf, ...)

calc_ss_3cmt_linear_oral_0(tad, tau, dose, dur, ...)

calc_ss_3cmt_linear_oral_0_lag(tad, tau, dose, dur, ...)

calc_ss_3cmt_linear_oral_1(tad, tau, dose, ...)
}
\arguments{
\item{tad}{Time after dose (h)}

\item{tau}{Dosing interval (h)}

\item{dose}{Dose}

\item{dur}{Duration of zero-order absorption (h)}

\item{tinf}{Duration of infusion (h)}

\item{...}{Passed to `calc_derived_3cpt()`}
}
\value{
Concentration of drug at requested time (\code{t}) at steady-state, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 3-compartment linear model at steady-state
}
\section{Functions}{
\itemize{
\item \code{calc_ss_3cmt_linear_bolus()}: Calculate C(t) for a 3-compartment linear model at steady state with IV bolus dosing

\item \code{calc_ss_3cmt_linear_oral_1_lag()}: Calculate C(t) for a 3-compartment linear model at steady-state with first-order oral dosing with a lag time

\item \code{calc_ss_3cmt_linear_infusion()}: Calculate C(t) for a 3-compartment linear model at steady state with IV infusions

\item \code{calc_ss_3cmt_linear_oral_0()}: Calculate C(t) for a 3-compartment linear model at steady state, with zero-order absorption

\item \code{calc_ss_3cmt_linear_oral_0_lag()}: Calculate C(t) for a 3-compartment linear model at steady state, with zero-order absorption and lag time

\item \code{calc_ss_3cmt_linear_oral_1()}: Calculate C(t) for a 3-compartment linear model at steady-state with first-order oral dosing

}}
\examples{
Ct <- calc_ss_3cmt_linear_bolus(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dose = 100, tau=24)
Ctrough <- calc_ss_3cmt_linear_oral_1_lag(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, ka = 1, dose = 100, tau=24, tlag = 1.5)
Ct <- calc_ss_3cmt_linear_infusion(tad = 11.75, CL = 2.5, V1 = 20, V2 = 50,
    V3 = 100, Q2 = 0.5, Q3 = 0.05, dose = 1000, tinf=1, tau=24)
Ct <- calc_ss_3cmt_linear_oral_0(tad = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dur = 1, dose = 100, tau = 24)
Ct <- calc_ss_3cmt_linear_oral_0_lag(tad = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dur = 1, dose = 100, tau = 24, tlag = 1.5)
Ct <- calc_ss_3cmt_linear_oral_1(tad = 11.75, CL = 3.5, V1 = 20,
    V2 = 500, V3 = 200, Q2 = 0.5, Q3 = 0.05, ka = 1, dose = 100, tau = 24)
}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{http://lixoft.com/wp-content/uploads/2016/03/PKPDlibrary.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
