% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_sd_2cmt_linear_oral_1_lag.R
\name{calc_sd_2cmt_linear_oral_1_lag}
\alias{calc_sd_2cmt_linear_oral_1_lag}
\title{Calculate C(t) for a 2-compartment linear model after a single first-order oral dose with a lag time}
\usage{
calc_sd_2cmt_linear_oral_1_lag(t, CL, V1, V2, Q, ka, dose, tlag)
}
\arguments{
\item{t}{Time after dose (h)}

\item{CL}{Clearance (L/h)}

\item{V1}{Central volume of distribution (L)}

\item{V2}{Peripheral volume of distribution (L)}

\item{Q}{Intercompartmental clearance (L/h)}

\item{ka}{First-order absorption rate constant (/h)}

\item{dose}{Steady state dose}

\item{tlag}{Lag time (h)}
}
\value{
Concentration of drug at requested time (\code{t}) after a single dose, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 2-compartment linear model after a single first-order oral dose with a lag time
}
\examples{
Ctrough <- calc_sd_2cmt_linear_oral_1_lag(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 1000, ka = 1, tlag = 2)

}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{http://lixoft.com/wp-content/uploads/2016/03/PKPDlibrary.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
