% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.ARIMA.R
\name{pmml.ARIMA}
\alias{pmml.ARIMA}
\title{Generate PMML for an ARIMA object the \bold{forecast} package.}
\usage{
\method{pmml}{ARIMA}(model, model_name = "ARIMA_model",
  app_name = "SoftwareAG PMML Generator",
  description = "ARIMA Time Series Model", copyright = NULL,
  transforms = NULL, missing_value_replacement = NULL, ...)
}
\arguments{
\item{model}{an ARIMA object from the package \pkg{forecast}.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the \code{ARIMA} object.
}
\description{
Generate PMML for an ARIMA object the \bold{forecast} package.
}
\details{
The model is represented in the PMML TimeSeriesModel format with conditional
least squares forecasting. Note that ARIMA models in R are
estimated using a state space formulation.

Transforms are currently not supported for ARIMA models.
}
\examples{
library(forecast)

# non-seasonal model
data("WWWusage")
mod <- Arima(WWWusage, order = c(3, 1, 1))
mod_pmml <- pmml(mod)

# seasonal model
data("JohnsonJohnson")
mod_02 <- Arima(JohnsonJohnson,
  order = c(1, 1, 1),
  seasonal = c(1, 1, 1)
)
mod_02_pmml <- pmml(mod_02)
}
\author{
Dmitriy Bolotov
}
