% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_summary.R
\name{summary.RNAFilt}
\alias{summary.RNAFilt}
\title{RNA Filter Summary}
\usage{
\method{summary}{RNAFilt}(object, size_library = NULL, min_nonzero = NULL, ...)
}
\arguments{
\item{object}{S3 object of class 'RNAFilt' created by
\code{\link{RNA_filter}}.}

\item{size_library}{integer cut-off for sample library size (i.e. number of
reads). Defaults to NULL.}

\item{min_nonzero}{integer or float between 0 and 1. Cut-off for number of
unique biomolecules with non-zero counts or as a proportion of total
biomolecules. Defaults to NULL.}

\item{...}{further arguments passed to or from other methods}
}
\value{
a summary table giving the minimum, maximum, 1st and 3rd quartiles,
  mean and standard deviation for library size (the number of unique
  biomolecules with non-zero observations per sample), and the proportion of
  non-zero observations over the total number of biomolecules.
}
\description{
Provide summary of a RNAFilt S3 object
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
myfilter <- RNA_filter(omicsData = rnaseq_object)
summary(myfilter)
summary(myfilter, min_nonzero = 2)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{RNA_filter}}
}
\author{
Rachel Richardson
}
