% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/petrinet.R
\name{petrinet_check_relaxed_soundness}
\alias{petrinet_check_relaxed_soundness}
\title{Check Relaxed soundness property}
\usage{
petrinet_check_relaxed_soundness(pn, im = NULL, fm = NULL, convert = TRUE)
}
\arguments{
\item{pn}{Petri net}

\item{im}{Initial marking of the Petri net (optional for workflow nets)}

\item{fm}{Final marking of the Petri net (optional for workflow nets)}

\item{convert}{\code{TRUE} to automatically convert Python objects to their R equivalent. If you pass \code{FALSE} you can do manual conversion using the \link[reticulate]{r-py-conversion} function.}
}
\value{
A single logical
}
\description{
Checks if the Petri net is relaxed sound
}
\examples{
if (pm4py_available()) {
  library(eventdataR)
  data(patients)

  # As Inductive Miner of PM4PY is not life-cycle aware, keep only `complete` events:
  patients_completes <- patients[patients$registration_type == "complete", ]

  net <- discovery_inductive(patients_completes)
  petrinet_check_relaxed_soundness(net$petrinet)

}
}
