% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau_handler.R
\name{tableau_handler}
\alias{tableau_handler}
\title{Create a Tableau-compliant handler for a function}
\usage{
tableau_handler(args, return, func)
}
\arguments{
\item{args}{A named list describing the arguments that are expected from
valid Tableau requests. The names in the named list can be any unique
variable names. The values in the named list must each be either a string
indicating the expected data type for that argument (\code{"character"},
\code{"logical"}, \code{"numeric"}, or \code{"integer"}); or better yet, a specification
object created by \code{\link[=arg_spec]{arg_spec()}}. If an argument should be considered
optional, then its data type should be followed by \verb{?}, like \code{"numeric?"}.}

\item{return}{A string indicating the data type that will be returned from
\code{func} (\code{"character"}, \code{"logical"}, \code{"numeric"}, or \code{"integer"}); or, a
specification object created by \code{\link[=return_spec]{return_spec()}}.}

\item{func}{A function to be used as the handler function. Code in the body
of the function will automatically be able to access Tableau request args
simply by referring to their names in \code{args}; see the example below.}
}
\value{
A \code{tableau_handler} object that is a validated version of the
provided \code{func} with additional attributes describing the expected arguments
and return values
}
\description{
Creates an object that can translate arguments from Tableau to R, and return
values from R to Tableau.
}
