% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau_extension.R
\name{tableau_extension}
\alias{tableau_extension}
\title{Modify a Plumber router to function as a Tableau Analytics Extension}
\usage{
tableau_extension

tableau_extension(pr)
}
\arguments{
\item{pr}{A plumber router}
}
\value{
A modified plumber router that functions as a Tableau Analytics
Extension
}
\description{
Most of the time, you won't call this function directly. Instead, you'll
place it at the end of a Plumber router, under a \verb{#* @plumber} annotation,
with no trailing parentheses or arguments. This tells Plumber to use the
function to modify the router object.
}
\examples{
\dontrun{
library(plumber)
library(plumbertableau)

#* Capitalize incoming text
#* @post /capitalize
function(req, res) {
  dat <- req$body$data
  toupper(dat)
}

#* @plumber
tableau_extension
}

}
