\name{dvvtz}
\Rdversion{1.1}
\alias{dvvtz}

\title{First derivative of the projection operator
}
\description{
This function computes the first derivative of the projection operator
\deqn{P_V z= V V^\top z}
}
\usage{
dvvtz(v, z, dv, dz)
}
\arguments{
  \item{v}{orthonormal basis of the space on which \code{z} is projected. \code{v} is either a matrix or a vector.
}
  \item{z}{vector that is projected onto the columns of \code{v}
}
  \item{dv}{first derivative of the the columns of \code{v} with respect to a vector y. If \code{v} is a matrix, 
  \code{dv} is an array of dimension \code{ncol(v)}x\code{nrow(v)}x\code{length(y)}. If \code{v} is a vector, \code{dv} is a 
  matrix of dimension \code{nrow(v)}x\code{length(y)}.
}
  \item{dz}{first derivative of \code{z} with respect to a vector y. This is a 
  matrix of dimension \code{nrow(v)}x\code{length(y)}.
}
}

\value{The first derivative of the projection operator with respect to y. This is a matrix of dimension \code{nrow(v)}x\code{length(y)}.}
\details{
For the computation of the first derivative, we assume that the columns of \code{v} are normalized and mutually orthogonal. (Note that the function will not return an error message if these assumptionsa are not fulfilled. If we denote the columns of \code{v} by \eqn{v_1,\ldots,v_l}, the first derivative of the projection operator is
\deqn{
\frac{\partial P}{\partial y}=\sum_{j=1} ^ l \left[ \left(v_j z^ \top + v_j^ \top z I_n  \right)\frac{\partial v_j}{\partial y} + v_j v_j ^ \top \frac{\partial z}{\partial y}\right]
}
Here, n denotes the length of the vectors \eqn{v_j}.

}
\references{
Kraemer, N., Sugiyama M. (2010). "The Degrees of Freedom of Partial Least Squares Regression". preprint, \url{http://arxiv.org/abs/1002.4112}

Kraemer, N., Braun, M.L. (2007) "Kernelizing PLS, Degrees of Freedom, and Efficient Model Selection", Proceedings of the 24th International Conference on Machine Learning, Omni Press, 441 - 448 

}
\author{
Nicole Kraemer, Mikio L. Braun
}
\note{This is an internal function.
}



\seealso{
 \code{\link{vvtz}}
}

\keyword{math}
