% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violinplots.r
\name{violinplots}
\alias{violinplots}
\title{Creates violin plots for the relationship between two measures for each group/unit}
\usage{
violinplots(x, y, group, data)
}
\arguments{
\item{x}{A vector.}

\item{y}{A vector.}

\item{group}{A vector that contains unit/group identifiers.}

\item{data}{A data frame.}
}
\value{
Violin plots for the relationship between two measures for each group/unit.
}
\description{
Returns violin plots for the relationship between two measures for each group/unit.
}
\examples{
\dontrun{
a <- runif(1000, min = 0, max = 1)
b <- a + rnorm(1000, mean = 0, sd =1)
c <- rep(c(1:10), times = 100)
data <- data.frame(a, b, c)
violinplots("a", "b", "c", data)
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}

