% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_or.R
\name{table_or}
\alias{table_or}
\title{Table OR}
\usage{
table_or(
  glm_model_results,
  conf_level = 0.95,
  output = "tibble",
  confint_fast_estimate = FALSE
)
}
\arguments{
\item{glm_model_results}{Results from a binomial Generalised Linear Model (GLM), as produced by \code{\link[stats:glm]{stats::glm()}}.}

\item{conf_level}{Numeric between 0.001 and 0.999 (default = 0.95). The confidence level to use when setting the confidence interval, most commonly will be 0.95 or 0.99 but can be set otherwise.}

\item{output}{String description of the output type. Default = 'tibble'. Options include 'tibble' and 'gt'.}

\item{confint_fast_estimate}{Boolean (default = \code{FALSE}) Should a faster estimate of the confidence interval be used? IMPORTANT, setting this to \code{TRUE} assumes normally distributed data, which may not be appropriate for your data.}
}
\value{
object returned depends on \code{output} parameter - output = 'tibble' returns an object of "tbl_df", "tbl", "data.frame" class, whilst output = 'gt' returns an object of class "gt_tbl" and "list".
}
\description{
Produces a formatted table showing the outputs from the Odds Ratio analysis.
}
\details{
Includes details on the characteristics of the covariates, such as:
\itemize{
\item the number of observations for each characteristic,
\item the number of observations resulting in the outcome of interest,
\item the conversion rate of outcome by the number of observations,
}

Details are calculated showing the:
\itemize{
\item estimated Odds Ratio, standard error and p-value,
\item calculated confidence interval for the confidence level,
}

Also included is a visualisation of the OR plot to provide an at-a-glance
view of the model results.
}
\examples{
# get some data
df <- datasets::Titanic |>
  dplyr::as_tibble() |>
  # convert aggregated counts to individual observations
  dplyr::filter(n > 0) |>
  tidyr::uncount(weights = n) |>
  # convert character variables to factors
  dplyr::mutate(dplyr::across(dplyr::where(is.character), as.factor))

# perform logistic regression using `glm`
lr <- stats::glm(
  data = df,
  family = 'binomial',
  formula = Survived ~ Class + Sex + Age
)

# produce the Odds Ratio table, first as a tibble then as gt object
table_or(lr)
table_or(lr, output = 'gt')
}
