% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotly.R
\name{ggplotly}
\alias{ggplotly}
\title{Create plotly graphs using ggplot2 syntax}
\usage{
ggplotly(p = ggplot2::last_plot(), filename, fileopt, world_readable = TRUE)
}
\arguments{
\item{p}{a ggplot object.}

\item{filename}{character string describing the name of the plot in your plotly account. 
Use / to specify directories. If a directory path does not exist it will be created.
If this argument is not specified and the title of the plot exists,
that will be used for the filename.}

\item{fileopt}{character string describing whether to create a "new" plotly, "overwrite" an existing plotly, 
"append" data to existing plotly, or "extend" it.}

\item{world_readable}{logical. If \code{TRUE}, the graph is viewable 
by anyone who has the link and in the owner's plotly account.
If \code{FALSE}, graph is only viewable in the owner's plotly account.}
}
\description{
See up-to-date documentation and examples at
\url{https://plot.ly/ggplot2}
}
\examples{
\dontrun{
# simple example
ggiris <- qplot(Petal.Width, Sepal.Length, data = iris, color = Species)
ggplotly(ggiris)

# maps!!
data(canada.cities, package = "maps")
viz <- ggplot(canada.cities, aes(long, lat)) +
  borders(regions = "canada", name = "borders") +
  coord_equal() +
  geom_point(aes(text = name, size = pop), colour = "red",
               alpha = 1/2, name = "cities")
 ggplotly(viz)
}

}
\author{
Carson Sievert
}
\seealso{
\link{signup}, \link{plot_ly}
}

