% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdap.R
\name{plotdap}
\alias{plotdap}
\title{Visualize rerddap data}
\usage{
plotdap(
  method = c("ggplot2", "base"),
  mapData = maps::map("world", plot = FALSE, fill = TRUE),
  crs = NULL,
  datum = sf::st_crs(4326),
  mapTitle = NULL,
  mapFill = "gray80",
  mapColor = "gray90",
  ...
)
}
\arguments{
\item{method}{the plotting method. Currently ggplot2 and base plotting
are supported.}

\item{mapData}{an object coercable to an sf object via \code{st_as_sf()}.}

\item{crs}{a coordinate reference system: integer with the epsg code,
or character with proj4string.}

\item{datum}{crs that provides datum to use when generating graticules.
Set to \code{NULL} to hide the graticule.}

\item{mapTitle}{a title for the map.}

\item{mapFill}{fill used for the map.}

\item{mapColor}{color used to draw boundaries of the map.}

\item{...}{arguments passed along to \code{geom_sf()}
(if \code{method='ggplot2'}, otherwise ignored).}
}
\value{
A plotdap object
}
\description{
Visualize data returned from rerddap servers. Use \code{plotdap()} to initialize
a plot, specify the plotting method (specifically, 'base' or 'ggplot2'),
and set some global options/parameters. Then use \code{add_tabledap()}
and/or \code{add_griddap()} to add "layers" of actual data to be visualized.
}
\details{
The "ggplot2" method is slower than "base" (especially
for high-res grids/rasters), but is more flexible/extensible. Additional ggplot2
layers, as well as scale defaults, labels, theming, etc. may be modified via
the \code{add_ggplot()} function. See the mapping vignette for an introduction
and overview of rerddap's visualization methods --
\code{browseVignettes(package = "rerddap")}.
}
\examples{

# base plotting tends to be faster (especially for grids),
# but is less extensible plotdap("base")

 plotdap()
 plotdap("base")


}
\seealso{
\code{tabledap()}, \code{griddap()}
}
\author{
Carson Sievert
}
