% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_resample}
\alias{mosaic_resample}
\title{A wrapper around terra::resample()}
\usage{
mosaic_resample(mosaic, y, ...)
}
\arguments{
\item{mosaic}{SpatRaster to be resampled}

\item{y}{SpatRaster with the geometry that x should be resampled to}

\item{...}{Further arguments passed on to \code{\link[terra:resample]{terra::resample()}}.}
}
\value{
SpatRaster
}
\description{
Transfers values between SpatRaster objects that do not align (have a
different origin and/or resolution). See \code{\link[terra:resample]{terra::resample()}} for more details
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
library(terra)
r <- rast(nrows=3, ncols=3, xmin=0, xmax=10, ymin=0, ymax=10)
values(r) <- 1:ncell(r)
s <- rast(nrows=25, ncols=30, xmin=1, xmax=11, ymin=-1, ymax=11)
x <- mosaic_resample(r, s, method="bilinear")
opar <- par(no.readonly =TRUE)
par(mfrow=c(1,2))
plot(r)
plot(x)
par(opar)
}
}
