% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{measure_disease_shp}
\alias{measure_disease_shp}
\title{Measure disease using shapefiles}
\usage{
measure_disease_shp(
  img,
  nrow = 1,
  ncol = 1,
  prepare = FALSE,
  viewer = "mapview",
  index_lb = "HUE2",
  index_dh = "NGRDI",
  pattern = NULL,
  threshold = NULL,
  invert = FALSE,
  dir_original = NULL,
  show_features = FALSE,
  interactive = FALSE,
  plot = TRUE,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{img}{The image to be analyzed. Either an image of class \code{Image} or a
character string containing the image name. In the last, the image will be
searched in the root directory. Declare dir_original to inform a subfolder
that contains the images to be processed.}

\item{nrow, ncol}{The number of rows and columns to generate the shapefile.
Defaults to \code{1}.}

\item{prepare}{Logical value indicating whether to prepare the image for
analysis using \code{\link[=image_prepare_mv]{image_prepare_mv()}} function. This allows to align and crop
the image before processing. Defaults to \code{FALSE}.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{index_lb}{The index used to segment the foreground (e.g., leaf) from
the background. If not declared, the entire image area (pixels) will be
considered in the computation of the severity.}

\item{index_dh}{The index used to segment diseased from healthy tissues when
\code{img_healthy} and \code{img_symptoms} are not declared. Defaults to \code{"GLI"}. See
\code{\link[=image_index]{image_index()}} for more details.}

\item{pattern}{A pattern of file name used to identify images to be
processed. For example, if \code{pattern = "im"} all images that the name
matches the pattern (e.g., img1.-, image1.-, im2.-) will be analyzed.
Providing any number as pattern (e.g., \code{pattern = "1"}) will select
images that are named as 1.-, 2.-, and so on.}

\item{threshold}{By default (\code{threshold = NULL}), a threshold value based on
Otsu's method is used to reduce the grayscale image to a binary image. If a
numeric value is informed, this value will be used as a threshold. Inform
any non-numeric value different than "Otsu" to iteratively choose the
threshold based on a raster plot showing pixel intensity of the index. Must
be a vector of length 2 to indicate the threshold for \code{index_lb} and
\code{index_dh}, respectively.}

\item{invert}{Inverts the binary image if desired. This is useful to process
images with black background. Defaults to \code{FALSE}.}

\item{dir_original}{The directory containing the original and processed images.
Defaults to \code{NULL}. In this case, the function will search for the image \code{img} in the
current working directory.}

\item{show_features}{If \code{TRUE} returnS the lesion features such as number,
area, perimeter, and radius. Defaults to \code{FALSE}.}

\item{interactive}{If \code{FALSE} (default) the grid is created automatically
based on the image dimension and number of rows/columns. If \code{interactive = TRUE}, users must draw points at the diagonal of the desired bounding box
that will contain the grid.}

\item{plot}{Show image after processing? Defaults to \code{TRUE}.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time, especially when \code{pattern} is used is informed. The
number of sections is set up to 70\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{...}{Aditional arguments passed on to \link{measure_disease}.}
}
\value{
An object of class \code{plm_disease_byl}. See more details in the \code{Value}
section of \code{\link[=measure_disease]{measure_disease()}}.
}
\description{
This function calls \code{\link[=measure_disease]{measure_disease()}} in each image polygon of a shapefile
object generated with \code{\link[=image_shp]{image_shp()}} and bind the results into read-ready data
frames.
}
\examples{
if(interactive()){
# severity for the three leaflets (from left to right)
img <- image_pliman("mult_leaves.jpg", plot = TRUE)
sev <-
 measure_disease_shp(img = img,
                     nrow = 1,
                     ncol = 3,
                     index_lb = "B",
                     index_dh = "NGRDI")
sev$severity
}
}
