\name{sonifyclass}
\alias{print.sonify}
\alias{summary.sonify}
\alias{+.sonify}
\alias{\%+\%}
\title{print, summary and addition methods for \code{sonify} objects}
\description{Methods to print and alter sonify objects. Printing a
  sonify object renders it to sound (analogously to how printing
  \code{ggplot} objects renders them to screen in the
  \href{http://had.co.nz/ggplot2}{ggplot2} package).}
\usage{
\method{print}{sonify}(x, \dots)
\method{summary}{sonify}(object, \dots)
\method{+}{sonify}(x, y)
x \%+\% y
}
\arguments{
  \item{x, object}{A \code{sonify} object}
  \item{y}{For \code{+}, a \code{sonscaling} object generated
    by \code{scaling()} or a \code{sonaes} object generated by
    \code{sonaes()} to add to \code{x}.

    For \code{\%+\%}, a \code{data.frame} to add to \code{x}.}
  
  \item{\dots}{Ignored.}
}
\value{
  \code{+} and \code{\%+\%} both return a sonify object with the
  relevant \code{y} value added into the object.

  \code{print.sonify} is called for its side-effect, which is to
  actually render the object to a sound.

  \code{summary.sonify} prints a brief summary of the name of the
  dataset to be sonified, and the specified mappings and scalings of
  sonic values to data parameters.
}

\details{The \code{print} method for \code{sonify} objects not only
  renders them to sound, it also creates an \code{audioSample} object
  (from the \code{audio} package), \code{.LastRendering}, in the user's
  workspace. \code{.LastRendering} is the output of the sonification and
  can be replayed or saved to a \code{.wav} file without regenerating
  the sonification from scratch with the convenience functions
  \code{\link{playLastRendering}} and \code{\link{saveLastRendering}}.}


 \seealso{
  \code{\link{sonify}} for the creation of these objects.}

  