% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{compile_model}
\alias{compile_model}
\title{Model Compiler}
\usage{
compile_model(
  mName,
  application = "mcsim",
  use_model_file = TRUE,
  version = "6.1.0"
)
}
\arguments{
\item{mName}{a string giving the name of the model code (without extension).}

\item{application}{a character to assign the specific methods (\code{mcsim} or \code{R})
that will be applied to the numerical analysis (default is \code{mcsim}).}

\item{use_model_file}{a logical value to operate the compiler to model or C file,
the default is set to \code{TRUE} to assign the \pkg{GNU MCSim}'s model file in compiling.}

\item{version}{a character to assign the version of \pkg{GNU MCSim} that had been installed.
The version must be assigned for Windows user (default is \code{6.1.0}).}
}
\value{
The default \code{application} is set to \code{'mcsim'}
to generate the executable program to solve differential equations by \pkg{GNU MCSim}.
If \code{application = 'R'},
the function will compile and create dynamic-link libraries (.dll) on Windows and
shared objects (.so) on Unix-likes systems (e.g., Linux and MacOS) that can link with \pkg{deSolve} solver.
}
\description{
The \code{compile_model} is used to compile the model code that is written under C or \pkg{GNU MCSim} format and
generate the executable program in numerical analysis.
}
\details{
Generally, the solving function through \pkg{GNU MCSim} can provide faster computing speed than exporting C in R.
Therefore, this function set \code{use_model_file = TRUE} and \code{application = 'mcsim'}
as a default setting, suggesting to use \pkg{GNU MCSim} as main solver to solve the differential equation.
To compile model code in Windows, be sure to install Rtools first.
In addition, the \code{version} of \pkg{GNU MCSim} should provide to conduct model compiling in Windows.
}
