## ----setup, include = FALSE----------------------------------------------
library(pksensi)
#mcsim_install()

knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.height=4, 
  fig.width=7
)

fn = local({ # not used function for fig caption
  i = 0
  function(x) {
    i <<- i + 1
    paste('Figure ', i, ': ', x, sep = '')
  }
})


## ---- eval=F-------------------------------------------------------------
#  pbtk1cpt_model()
#  cat(readLines("pbtk1cpt.model"), sep = "\n")

## ----eval=F, message=FALSE, warning=FALSE--------------------------------
#  mName <- "pbtk1cpt"
#  compile_model(mName, application = "R")

## ---- eval=F-------------------------------------------------------------
#  source(paste0(mName, "_inits.R"))

## ---- eval=F-------------------------------------------------------------
#  parms <- initParms()
#  parms["vdist"] <- 1.1
#  parms["ke"] <- 0.23
#  parms["kgutabs"] <- 2.18
#  parms["BW"] <- 70
#  initState <- initStates(parms=parms)
#  initState["Agutlument"] <- 10

## ---- eval=F-------------------------------------------------------------
#  parms

## ---- eval=F-------------------------------------------------------------
#  initState

## ---- eval=F-------------------------------------------------------------
#  Outputs

## ---- eval=F-------------------------------------------------------------
#  t <- seq(from = 0.01, to = 24.01, by = 1)
#  y <- deSolve::ode(initState, t, func = "derivs", parms = parms,
#           dllname = mName, initfunc = "initmod",
#           nout = 1, outnames = Outputs)

## ---- eval=F, fig.cap = '**Figure 1.** Simulation results of one-compartment PK model.'----
#  plot(y)

## ---- eval=F-------------------------------------------------------------
#  q <- c("qunif", "qunif", "qunif", "qnorm")
#  q.arg <- list(list(min = parms["vdist"] / 2, max = parms["vdist"] * 2),
#               list(min = parms["ke"] / 2, max = parms["ke"] * 2),
#               list(min = parms["kgutabs"] / 2, max = parms["kgutabs"] * 2),
#               list(mean = parms["BW"], sd = 5))
#  params <- c("vdist", "ke", "kgutabs", "BW")

## ---- eval=F-------------------------------------------------------------
#  set.seed(1234)
#  x <- rfast99(params, n = 200, q = q, q.arg = q.arg, replicate = 20)

## ---- eval=F-------------------------------------------------------------
#  dim(x$a)

## ---- eval=F, fig.cap = '**Figure 2.** The parameter search curve generated by eFAST method. The x-axis is the sample number and y-axis is the parameter value for `vdist`, \`ke`, `kgutabs`, and \`BW` (top to down), respectively. The bar plot shows the distribution of sampling parameter.', fig.height=5----
#  par(mfrow=c(4,4),mar=c(0.8,0.8,0.8,0),oma=c(4,4,2,1), pch =".")
#  for (j in c("vdist", "ke", "kgutabs", "BW")) {
#    if ( j == "BW") {
#      plot(x$a[,1,j], ylab = "BW")
#    } else plot(x$a[,1,j], xaxt="n", ylab = "")
#    for (i in 2:3) {
#    if ( j == "BW") {
#      plot(x$a[,i,j], ylab = "", yaxt="n")
#      } else plot(x$a[,i,j], xaxt="n", yaxt="n", ylab = "")
#    }
#    hist <- hist(x$a[,,j], plot=FALSE,
#                 breaks=seq(from=min(x$a[,,j]), to=max(x$a[,,j]), length.out=20))
#    barplot(hist$density, axes=FALSE, space=0, horiz = T, main = j)
#  }
#  mtext("Model evaluation", SOUTH<-1, line=2, outer=TRUE)

## ---- eval=F-------------------------------------------------------------
#  outputs <- c("Ccompartment", "Ametabolized")
#  out <- solve_fun(x, time = t, initState = initState,
#                   outnames = outputs, dllname = mName)

## ---- eval=F, fig.cap = '**Figure 3.** Time-dependent SI of the plasma concentration estimated from one-compartment PK model during 24-hr time period intake. The solid line represent the total (black) and first (red) order SI with 95\\% confidence interval (polygon). The dash line is the cut-off with default value of 0.05.'----
#  plot(out)

## ---- eval=F, fig.cap = '**Figure 4.** Time-dependent SI of the plasma concentration estimated from one-compartment PK model during 24-hr time period intake.'----
#  plot(out, vars = "Ametabolized")

## ---- eval=F, fig.cap = '**Figure 5.** The relationship between model parameter and estimated concentration at times 0.01, 2.01, 6.01, and 24.01 hr (top to bottom), respectively.'----
#  par(mfcol=c(4,4),mar=c(0.8,0.8,0,0),oma=c(4,4,2,1), pch = ".")
#  plot(x$a[,1,"vdist"], out$y[,1,"0.01",1], xaxt="n", main = "\nvdist")
#  plot(x$a[,1,"vdist"], out$y[,1,"2.01",1], xaxt="n")
#  plot(x$a[,1,"vdist"], out$y[,1,"6.01",1], xaxt="n")
#  plot(x$a[,1,"vdist"], out$y[,1,"24.01",1])
#  for (j in c("ke", "kgutabs", "BW")){
#    for (k in c("0.01", "2.01", "6.01", "24.01")){
#      if (k == "0.01") {
#        plot(x$a[,1,j], out$y[,1,k,1], yaxt = "n", xaxt="n", main = paste0("\n", j))
#      } else if (k == "24.01") {
#        plot(x$a[,1,j], out$y[,1,k,1], yaxt = "n")
#        } else plot(x$a[,1,j], out$y[,1,k,1], xaxt = "n", yaxt = "n")
#    }
#  }
#  mtext("Parameter", SOUTH<-1, line=2, outer=TRUE)
#  mtext("Ccompartment", WEST<-2, line=2, outer=TRUE)

## ---- eval=F-------------------------------------------------------------
#  dim(out$y)

## ---- eval=F-------------------------------------------------------------
#  check(out, SI.cutoff = 0.05)

## ---- eval=F-------------------------------------------------------------
#  system.time(out<-solve_fun(x, t, initState = initState,
#                             outnames = Outputs, dllname = mName))

## ---- eval=F, message=F, warning=F---------------------------------------
#  compile_model(mName, application = "mcsim")

## ---- eval=F-------------------------------------------------------------
#  conditions <- c("Agutlument = 10")
#  system.time(out <- solve_mcsim(x, mName = mName, params = params,
#                                 vars = Outputs, time = t,
#                                 condition = conditions))

