% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crandb-public-api.R
\name{cran_packages}
\alias{cran_packages}
\title{Metadata about multiple CRAN packages}
\usage{
cran_packages(names)
}
\arguments{
\item{names}{Package names. May also contain versions, separated by a
\verb{@} character.}
}
\value{
A data frame of package metadata, one package per row.
}
\description{
Metadata about multiple CRAN packages
}
\examples{
\dontshow{ asNamespace("pkgsearch")$exif(pingr::is_online(), \{ }
# Get metadata about one package
cran_packages("rhub")
# Get metadata about two packages
cran_packages(c("rhub", "testthat"))
# Get metadata about two packages at given versions
cran_packages(c("rhub@1.1.1", "testthat@2.2.1", "testthat@2.2.0"))
# If a version does not exist nothing is returned
cran_packages("rhub@notaversion")
\dontshow{ \}) }
}
