\name{pkgndep}
\alias{pkgndep}
\title{
Number of dependency packages
}
\description{
Number of dependency packages
}
\usage{
pkgndep(package, load = FALSE, verbose = TRUE)
}
\arguments{

  \item{package}{Package name if the package is already installed or the path of the package in the file system.}
  \item{load}{Whether also check which other packages are loaded into R session (directly or indirectly) when loading \code{pkg}. }
  \item{verbose}{Whether to show messages.}

}
\details{
The package database for dependency analysis is always directly retrieved from CRAN/Bioconductor.
}
\value{
A \code{pkgndep} object.
}
\examples{
\dontrun{
x = pkgndep("ComplexHeatmap")
}
# The `x` variable generated by `pkgndep()` is already saved in this package.
x = readRDS(system.file("extdata", "ComplexHeatmap_dep.rds", package = "pkgndep"))
x
plot(x)
}
