% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-tutorials.R
\name{build_tutorials}
\alias{build_tutorials}
\title{Build tutorials section}
\usage{
build_tutorials(pkg = ".", override = list(), preview = NA)
}
\arguments{
\item{pkg}{Path to package.}

\item{override}{An optional named list used to temporarily override
values in \verb{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}
}
\description{
learnr tutorials must be hosted elsewhere as they require an
R execution engine. Currently, pkgdown will not build or publish tutorials
for you, but makes it easy to embed (using \verb{<iframe>}s) published tutorials.
Tutorials are automatically discovered from published tutorials in
\code{inst/tutorials} and \code{vignettes/tutorials}. Alternatively, you can
list in \verb{_pkgdown.yml} as described below.
}
\section{YAML config}{

To override the default discovery process, you can provide a \code{tutorials}
section. This should be a list where each element specifies:
\itemize{
\item \code{name}: used for the generated file name
\item \code{title}: used in page heading and in navbar
\item \code{url}: which will be embedded in an iframe
\item \code{source}: optional, but if present will be linked to
}

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{tutorials:
- name: 00-setup
  title: Setting up R
  url: https://jjallaire.shinyapps.io/learnr-tutorial-00-setup/
- name: 01-data-basics
  title: Data basics
  url: https://jjallaire.shinyapps.io/learnr-tutorial-01-data-basics/
}\if{html}{\out{</div>}}
}

