% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-site.R
\name{deploy_to_branch}
\alias{deploy_to_branch}
\title{Build and deploy a site locally}
\usage{
deploy_to_branch(
  pkg = ".",
  commit_message = construct_commit_message(pkg),
  clean = TRUE,
  branch = "gh-pages",
  remote = "origin",
  github_pages = (branch == "gh-pages"),
  ...
)
}
\arguments{
\item{pkg}{Path to package.}

\item{commit_message}{The commit message to be used for the commit.}

\item{clean}{Clean all files from old site.}

\item{branch}{The git branch to deploy to}

\item{remote}{The git remote to deploy to}

\item{github_pages}{Is this a GitHub pages deploy. If \code{TRUE}, adds a \code{CNAME}
file for custom domain name support, and a \code{.nojekyll} file to suppress
jekyll rendering.}

\item{...}{Additional arguments passed to \code{\link[=build_site]{build_site()}}.}
}
\description{
Assumes that you're in a git clone of the project, and the package is
already installed. Use \code{\link[usethis:use_pkgdown]{usethis::use_pkgdown_github_pages()}} to automate
this process using GitHub actions.
}
