% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name-check.R
\name{pkg_name_check}
\alias{pkg_name_check}
\title{Check if an R package name is available.}
\usage{
pkg_name_check(name, dictionaries = NULL)
}
\arguments{
\item{name}{Package name candidate.}

\item{dictionaries}{Character vector, the dictionaries to query.
Available dictionaries:
* \code{wikipedia}
* \code{wiktionary},
* \code{acromine} (\url{http://www.nactem.ac.uk/software/acromine/}),
* \code{sentiment} (\url{https://github.com/fnielsen/afinn}),
* \code{urban} (Urban Dictionary).
If \code{NULL} (by default), the Urban Dictionary is omitted, as it
is often offensive.}
}
\value{
\code{pkg_name_check} object with a custom print method.
}
\description{
Additionally, look up the candidate name in a number of
dictionaries, to make sure that it does not have a negative
meaning.
}
\details{
\subsection{Valid package name check}{

Check the validity of \code{name} as a package name. See 'Writing R
Extensions' for the allowed package names. Also checked against a list
of names that are known to cause problems.
}

\subsection{CRAN checks}{

Check \code{name} against the names of all past and current packages on
CRAN, including base and recommended packages.
}

\subsection{Bioconductor checks}{

Check \code{name} against all past and current Bioconductor packages.
}

\subsection{Profanity check}{

Check \code{name} with \url{https://www.purgomalum.com/service/containsprofanity}
to make sure it is not a profanity.
}

\subsection{Dictionaries}{

See the \code{dictionaries} argument.
}
}
\examples{
\dontrun{
pkg_name_check("cli")
}
}
