% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suppress.R
\name{suppress}
\alias{suppress}
\alias{suppress_conditions}
\alias{suppress_warnings}
\alias{suppress_messages}
\title{Selectively suppress warnings and messages}
\usage{
suppress_conditions(expr, pattern = NULL, class = NULL, ...)

suppress_warnings(expr, pattern = NULL, class = "warning", ...)

suppress_messages(expr, pattern = NULL, class = "message", ...)
}
\arguments{
\item{expr}{An expression to evaluate.}

\item{pattern}{A regular expression pattern to match on.}

\item{class}{The class or classes that you would like to filter.
When more that one is given the condition may match any
of the classes.}

\item{...}{Arguments passed on to \code{base::grepl}
\describe{
  \item{pattern}{character string containing a \link{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr} and \code{gregexpr}.}
  \item{x}{a character vector where matches are sought, or an
    object which can be coerced by \code{as.character} to a character
    vector.  \link{Long vectors} are supported.}
  \item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}
  \item{perl}{logical.  Should Perl-compatible regexps be used?}
  \item{fixed}{logical.  If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}
  \item{useBytes}{logical.  If \code{TRUE} the matching is done
    byte-by-byte rather than character-by-character.  See
    \sQuote{Details}.}
}}
}
\description{
This collection of functions allow the suppression of condition messages,
warnings and messages, through filtering the condition message, the condition
class or a combination of the two.
}
\section{Functions}{
\itemize{
\item \code{suppress_conditions}: The general case of suppressing both messages and warnings.

\item \code{suppress_warnings}: A convenience wrapper that specifies warning class to suppress.

\item \code{suppress_messages}: A convenience wrapper that specifies warning class to suppress.
}}

\examples{
\dontrun{
testit <- function(){
    warning("this function does nothing.")
    warning("it's pretty useless.")
}
suppress_warning(testit(), "useless")  # Will suppress only the second warning by pattern


# If my_pkg used pkgcond for conditions,
# This would suppress all messages and warnings originating
# in my_pkg functions.
suppress_conditions(my_function(), class='my_pkg-condition')
}
}
