% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_float.R
\name{sprinkle_float}
\alias{sprinkle_float}
\alias{sprinkle_float.default}
\alias{sprinkle_float.dust_list}
\title{Change the float Property in a Dust Table}
\source{
\url{https://en.wikibooks.org/wiki/LaTeX/Floats,_Figures_and_Captions}
}
\usage{
sprinkle_float(x, float = getOption("pixie_float", FALSE), ...)

\method{sprinkle_float}{default}(x, float = getOption("pixie_float", FALSE), ...)

\method{sprinkle_float}{dust_list}(x, float = getOption("pixie_float", FALSE), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{float}{\code{logical(1)} indicating if the table should be placed in
a floating environment.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
Alter the floating behavior of tables rendered in 
LaTeX documents.  Floating tables are moved to a position deemed ideal 
by the typesetter.  Setting \code{float = FALSE} causes the table to 
be rendered in the position in which it is generated in the code.
}
\details{
See \url{https://en.wikibooks.org/wiki/LaTeX/Floats,_Figures_and_Captions}
for more about floating environments in LaTeX.

This property has no effect on non-LaTeX output.
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{float} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{float} is not logical or length 1.
}
}

\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}
}
\author{
Benjamin Nutter
}
