% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_merge.R
\name{sprinkle_merge}
\alias{sprinkle_merge}
\alias{sprinkle_merge.default}
\alias{sprinkle_merge.dust_list}
\title{Sprinkle Table Cells to Merge}
\usage{
sprinkle_merge(x, rows = NULL, cols = NULL, merge = FALSE,
  merge_rowval = NULL, merge_colval = NULL, part = c("body", "head",
  "foot", "interfoot", "table"), fixed = FALSE, recycle = c("none", "rows",
  "cols", "columns"), ...)

\method{sprinkle_merge}{default}(x, rows = NULL, cols = NULL,
  merge = FALSE, merge_rowval = NULL, merge_colval = NULL,
  part = c("body", "head", "foot", "interfoot", "table"), fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"), ...)

\method{sprinkle_merge}{dust_list}(x, rows = NULL, cols = NULL,
  merge = FALSE, merge_rowval = NULL, merge_colval = NULL,
  part = c("body", "head", "foot", "interfoot", "table"), fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{merge}{\code{logical} Defaults to \code{FALSE}, prompting no 
merging action.}

\item{merge_rowval}{The row position of the cell whose content will be
displayed.  Defaults to the minimum of \code{rows}.}

\item{merge_colval}{The column position of the cell whose content will 
be displayed.  Deafults to the minimum of \code{cols}.}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
Merging cells creates more space for values to be displayed
  without disrupting the appearance of other cells in the same row or 
  column.  The downside is that the content from only one of the cells
  in the merge range will be displayed.
}
\section{Functional Requirements}{

\enumerate{
 \item Correctly reassigns the appropriate elements of \code{merge}, 
   \code{merge_rowval} and \code{merge_colval} columns in the table part.
 \item Casts an error if \code{x} is not a \code{dust} object.
 \item Casts an error if \code{merge} is not a \code{logical(1)}
 \item Casts an error if \code{merge_rowval} is not a \code{numeric(1)}
 \item Casts an error if \code{merge_colval} is not a \code{numeric(1)}
 \item Casts an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}
 \item Casts an error if \code{fixed} is not a \code{logical(1)}
 \item Casts an error if \code{recycle} is not one of \code{"none"},
   \code{"rows"}, or \code{"cols"}
}

The functional behavior of the \code{fixed} and \code{recycle} arguments 
is not tested for this function. It is tested and validated in the
tests for \code{\link{index_to_sprinkle}}.
}

\seealso{
\code{\link{sprinkle}}, 
  \code{\link{index_to_sprinkle}}
}
