% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/glance_foot.R
\name{glance_foot}
\alias{glance_foot}
\title{Prepare Glance Statistics for \code{pixiedust} Table Footer}
\usage{
glance_foot(fit, col_pairs, total_cols, glance_stats = NULL, byrow = FALSE)
}
\arguments{
\item{fit}{A model object with a \code{broom::glance} method.}

\item{col_pairs}{An integer indicating the number of column-pairings for the
glance output.  This must be less than half the total number of columns,
as each column-pairing includes a statistic name and value.}

\item{total_cols}{The total number of columns in the body of the pixiedust table}

\item{glance_stats}{A character vector giving the names of the glance statistics
to put in the output.  When \code{NULL}, the default, all of the available
statistics are retrieved.  In addition to controlling which statistics are
printed, this also controls the order in which they are printed.}

\item{byrow}{A logical, defaulting to \code{FALSE}, that indicates if the
  requested statistics are placed with priority to rows or columns.  See Details.}
}
\description{
Retrieves the \code{broom::glance} output for a model object and
  structures it into a table suitable to be placed in the footer.  By default,
  the statistics are displayed in two column-pairings (see Details).  This
  function is not exported but is documented to maintain clarity of its
  behavior.  It is intended for use within \code{dust}, but may be useful
  elsewhere if used with caution.
}
\details{
Statistics are placed in column-pairings.  Each column pair consists of
  two columns named \code{stat_name_x} and \code{stat_value_x}, where \code{x} is
  the integer index of the column pair.  The column-pairings are used to allow
  the user to further customize the output, more-so than pasting the name and
  value together would allow.  With this design, statistics can be rounded
  differently by applying sprinkles to the resulting table.

  The total number of column-pairings must be less than or equal to half the
  number of total columns.  This constraint prevents making glance tables that
  have more columns than the model table it accompanies.

  When the total number of column-parings is strictly less than half the total
  number of columns, "filler" columns are placed between the column pairings.
  As much as possible, the filler columns are placed evenly between the
  column pairings, but when the number of filler columns is unequal between
  column-pairings, there will be more space placed on the left side.  For example,
  if a table has 7 columns and 3 column-pairings, the order of placement would be
  column-pair-1, filler, column-pair-2, column-pair-3.  Since there was only room
  for one column of filler, it was placed in the left most fill position.

  The \code{byrow} arguments acts similarly to the \code{byrow} argument in the
  \code{matrix} function, but defaults to \code{FALSE}.  If four statistics are
  requested and \code{byrow = FALSE}, the left column-pair will have statistics
  one and two, while the right column-pair will have statistics three and four.
  If \code{byrow = TRUE}, however, the left column-pair will have statistics
  one and three, while the right column-pair will have statistics two and four.
}
\author{
Benjamin Nutter
}

