% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_query.R
\name{build_query}
\alias{build_query}
\title{Build the query}
\usage{
build_query(
  date_from,
  date_to,
  website_id,
  columns,
  filters = NULL,
  metric_filters = NULL,
  offset = 0,
  max_lines = 0
)
}
\arguments{
\item{date_from}{Start date of query}

\item{date_to}{End date of query}

\item{website_id}{website_id from piwik}

\item{columns}{tibble containing columns and transformations (metrics and dimensions)}

\item{filters}{list containing filter, best built by \code{\link{build_filter}}}

\item{metric_filters}{list containing filter, best built by \code{\link{build_filter}}}

\item{offset}{offset}

\item{max_lines}{limit}
}
\value{
query as list
}
\description{
Build the query
}
\examples{
columns <- tibble::tribble(
  ~column, ~transformation,
  "event_url", "to_path",
  "event_url", "to_domain",
  "website_name", "",
  "timestamp", "",
  "timestamp", "to_hour_of_day",
  "page_views", ""
  )
  build_query(lubridate::ymd("2021-01-01"), lubridate::ymd("2021-01-19"), "xxx",
              columns
  )

}
