% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_model_type.R
\name{check_model_type}
\alias{check_model_type}
\title{Checks if model type is valid
Will \link{stop} if not.}
\usage{
check_model_type(model_type)
}
\arguments{
\item{model_type}{type of inference model supplied for an experiment.
Possible values:
\itemize{
  \item \code{generative}: the inference model is (or is assumed to be)
    the inference model underlying the phylogeny
  \item \code{candidate}: the inference model is a candidate model,
    that competes with other models for having the most
    evidence (aka highest marginal likelihood)
}}
}
\value{
nothing. Will \link{stop} if not
}
\description{
Checks if model type is valid
Will \link{stop} if not.
}
\examples{
check_model_type(get_model_type_names()[1])
check_model_type(get_model_type_names()[2])
}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
