% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_transform_throw_error}
\alias{process_transform_throw_error}
\title{Validate and clean transform function output}
\usage{
process_transform_throw_error(input_df, output_df, func_name)
}
\arguments{
\item{input_df}{The original (input data) data.frame - the transform function's argument.}

\item{output_df}{The the transform function's output.}

\item{func_name}{The name of the \code{ml_pipeline_builder} trandform method.}
}
\value{
If the transform function is not \code{NULL} then a copy of the transform function's
output data.frame, with any duplicated inputs removed.
}
\description{
Helper function that ensures the output of applying a transform function is a data.frame and
that this data frame does not duplicate variables from the original (input data) data frame. If
duplicates are found they are automatically dropped from the data.frame that is returned by this
function.
}
\examples{
\dontrun{
transform_method <- function(df) cbind_fast(df, q = df$y * df$y)
data <- data.frame(y = c(1, 2), x = c(0.1, 0.2))
data_transformed <- transform_method(data)
process_transform_throw_error(data, data_transformed, "transform_method")
# transform_method yields data.frame that duplicates input vars - dropping the following
columns: 'y', 'x'
# q
# 1 1
# 2 4
}
}

