% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_registration.R
\name{board_register_azure}
\alias{board_register_azure}
\title{Register Azure Board}
\usage{
board_register_azure(
  name = "azure",
  container = Sys.getenv("AZURE_STORAGE_CONTAINER"),
  account = Sys.getenv("AZURE_STORAGE_ACCOUNT"),
  key = Sys.getenv("AZURE_STORAGE_KEY"),
  cache = board_cache_path(),
  ...
)
}
\arguments{
\item{name}{Optional name for this board, defaults to 'azure'.}

\item{container}{The name of the Azure Storage container. Defaults to the \code{AZURE_STORAGE_CONTAINER} environment
variable.}

\item{account}{The account of the Azure Storage container. Defaults to the \code{AZURE_STORAGE_ACCOUNT} environment
variable.}

\item{key}{The key of the Azure Storage container Defaults to the \code{AZURE_STORAGE_KEY} environment
variable.}

\item{cache}{The local folder to use as a cache, defaults to \code{board_cache_path()}.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Wrapper with explicit parameters over \code{board_register()} to
register a Microsoft Azure Storage Blob as a board.
}
\details{
This function requires an Azure Storage container to be manually created; otherwise,
registering an Azire board will fail.
}
\examples{
\dontrun{
# the following example requires an Azure Storage key
board_register_azure(container = "pinscontainer",
                     account = "pinsstorage",
                     key = "abcabcabcabcabcabcabcabcabcab==")
}
}
\seealso{
board_register
}
