% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{eng_pikchr}
\alias{eng_pikchr}
\title{Pikchr Code Engine for Knitr}
\usage{
eng_pikchr(options)
}
\arguments{
\item{options}{A list of chunk options from Knitr. It includes the Pikchr code and various parameters
controlling the size, appearance, and output format of the rendered image.}
}
\value{
This function returns an SVG (or PNG for LaTeX output) rendered by Pikchr.
}
\description{
This function serves as a custom code engine for Knitr to render Pikchr diagrams as SVG or PNG images.
It processes Pikchr code embedded in R Markdown documents and outputs either HTML or LaTeX-compatible images.
}
\details{
The `eng_pikchr` function allows you to use Pikchr code inside R Markdown documents, rendering it as an image.
It supports options like `width`, `height`, `font size`, `font family`, and CSS classes to customize the output.
The function automatically detects the output format (HTML or LaTeX) and generates the appropriate image.

If the output is LaTeX, the SVG is converted to PNG using the `rsvg_png()` function.
}
\section{Chunk Options}{

- `eval`: Whether to evaluate the Pikchr code (default `TRUE`).
- `echo`: Whether to display the code in the output document (default `TRUE`).
- `width`: Width of the rendered image (default `"80%"`).
- `height`: Height of the rendered image (default `"auto"`).
- `size`: Font size for the Pikchr diagram (default `"100%"`).
- `family`: Font family for the Pikchr diagram (default `"inherit"`).
- `css`: Additional CSS for customizing the Pikchr diagram.
- `class`: CSS class to apply to the diagram (default `"pikchr"`).
- `margin`: CSS margin around the image (default `"10px 0 10px 0"`).
- `lang`: Language for the Pikchr diagram (optional).
}

\seealso{
[knitr::knit_engines]
}
\keyword{internal}
