% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_fn_helpers.R
\name{grob_fn_helpers}
\alias{grob_fn_helpers}
\alias{gridlinesGrob}
\alias{matGrob}
\alias{checkersGrob}
\alias{hexlinesGrob}
\alias{get_shape_grob_fn}
\alias{is_color_invisible}
\title{\code{pieceGrob} helper functions}
\usage{
gridlinesGrob(col, shape = "rect", shape_t = 90, lex = 1, name = NULL)

matGrob(col, shape = "rect", shape_t = 90, mat_width = 0, name = NULL)

checkersGrob(col, shape = "rect", shape_t = 90, name = NULL)

hexlinesGrob(col, shape = "rect", name = NULL)

get_shape_grob_fn(shape, shape_t = 90, shape_r = 0.2)

is_color_invisible(col)
}
\arguments{
\item{col}{Color}

\item{shape}{String of the shape}

\item{shape_t}{Angle (in degrees) of first vertex of shape (ignored by many shapes).}

\item{lex}{Multiplier to apply to the line width}

\item{name}{A character identifier (for grid)}

\item{mat_width}{Numeric vector of mat widths}

\item{shape_r}{Radial distance (from 0 to 0.5) (ignored by most shapes)}
}
\description{
\code{gridlinesGrob} returns a grob that produces gridlines.
\code{matGrob} returns a grob that produces a mat.
\code{checkersGrob} returns a grob that adds checkers.
\code{hexlinesGrob} returns a grob that adds hexlines.
\code{get_shape_grob_fn} returns a function that returns a grob of the piece shape.
\code{is_color_invisible} tells whether the color is transparent (and hence need not be drawn).
}
\examples{
 is_color_invisible("transparent")
 is_color_invisible(NA)
 is_color_invisible("blue")
 is_color_invisible("#05AE9C")

 if (require("grid")) {
     gp <- gpar(col="black", fill="yellow")
     pushViewport(viewport(x=0.25, y=0.75, width=1/2, height=1/2))
     grid.draw(get_shape_grob_fn("rect")(gp=gp))
     grid.draw(gridlinesGrob("blue", lex=4))
     grid.draw(hexlinesGrob("green"))
     popViewport()

     pushViewport(viewport(x=0.75, y=0.75, width=1/2, height=1/2))
     grid.draw(get_shape_grob_fn("convex6")(gp=gp))
     grid.draw(checkersGrob("blue", shape="convex6"))
     popViewport()

     pushViewport(viewport(x=0.25, y=0.25, width=1/2, height=1/2))
     grid.draw(get_shape_grob_fn("circle")(gp=gp))
     grid.draw(matGrob("blue", shape="circle", mat_width=0.2))
     popViewport()

     pushViewport(viewport(x=0.75, y=0.25, width=1/2, height=1/2))
     grid.draw(get_shape_grob_fn("rect")(gp=gp))
     grid.draw(matGrob("blue", shape="rect", mat_width=c(0.2, 0.1, 0.3, 0.4)))
     popViewport()
 }

}
