% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{validate_utf8}
\alias{validate_utf8}
\title{Clean Up Text to UTF-8}
\usage{
validate_utf8(text)
}
\arguments{
\item{text}{A character vector to clean.}
}
\value{
The text with formal UTF-8 encoding, if possible.
}
\description{
Text cleaning works best if the encoding is known. This function attempts to
convert text to UTF-8 encoding, and provides an informative error if that is
not possible.
}
\examples{
text <- "fa\xE7ile"
# Specify the encoding so the example is the same on all systems.
Encoding(text) <- "latin1"
validate_utf8(text)
}
