% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylotaR.R
\name{parameters}
\alias{parameters}
\title{Default parameters}
\usage{
parameters(wd = ".", txid = character(), mkblstdb = "", blstn = "",
  v = FALSE, ncps = 1, mxnds = 1e+05, mdlthrs = 3000, mnsql = 250,
  mxsql = 2000, mxrtry = 100, mxsqs = 50000, mxevl = 1e-10,
  mncvrg = 51, btchsz = 100, date = Sys.Date())
}
\arguments{
\item{wd}{The working directory where all output files are saved.}

\item{txid}{Taxonomic group of interest, allows vectors.}

\item{mkblstdb}{File path to makeblastdb}

\item{blstn}{File path to blastn}

\item{v}{Print progress statements to console?
Statements will always be printed to log.txt.}

\item{ncps}{The number of threads to use in the local-alignment search tool.}

\item{mxnds}{The maximum number of nodes descending from a taxonomic group.
If there are more than this number, nodes at the lower taxonomic level are
analysed.}

\item{mdlthrs}{'Model organism threshold'. Taxa with more sequences than this
number will be considered model organisms and a random mdlthrs subset of
their sequences will be downloaded.}

\item{mnsql}{The minimum length of sequence in nucleotide base pairs to
download.}

\item{mxsql}{The maximum length of sequence in nucleotide base pairs to
download. Any longer sequences will be ignored.}

\item{mxrtry}{The maximum number of attempts to make when downloading.}

\item{mxsqs}{The maximum number of sequences to BLAST in all-vs-all searches.
If there are more sequences for a node, BLAST is performed at the lower
taxonomic level.}

\item{mxevl}{The maximum E-value for a successful BLAST.}

\item{mncvrg}{The maximum percentile coverage defining an overlapping BLAST hit.
Sequences with BLAST matches with lower values are not considered orthologous.}

\item{btchsz}{Batch size when querying NCBI}

\item{date}{Date when pipeline was initiated}
}
\value{
list
}
\description{
Returns a parameter list with default parameter values.
}
\details{
This function is NOT used to change the parameters in a folder.
Use parameters_reset() instead. The purpose of this function is to describe
the paramaters and present their default values.
}
