% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{class}
\name{SeqRec-class}
\alias{SeqRec-class}
\alias{SeqRec-method}
\alias{as.character,SeqRec-method}
\alias{show,SeqRec-method}
\alias{print,SeqRec-method}
\alias{str,SeqRec-method}
\alias{summary,SeqRec-method}
\title{Sequence record}
\usage{
\S4method{as.character}{SeqRec}(x)

\S4method{show}{SeqRec}(object)

\S4method{print}{SeqRec}(x)

\S4method{str}{SeqRec}(object, max.level = 2L, ...)

\S4method{summary}{SeqRec}(object)
}
\arguments{
\item{x}{\code{SeqRec} object}

\item{object}{\code{SeqRec} object}

\item{max.level}{Maximum level of nesting for str()}

\item{...}{Further arguments for str()}
}
\description{
Sequence record contains sequence data.
}
\details{
Sequence is stored as raw. Use rawToChar().
}
\section{Slots}{

\describe{
\item{\code{id}}{Unique ID}

\item{\code{nm}}{Best-guess sequence name}

\item{\code{accssn}}{Accession}

\item{\code{vrsn}}{Accession version}

\item{\code{url}}{URL}

\item{\code{txid}}{Taxonomic ID of source taxon}

\item{\code{orgnsm}}{Scientific name of source taxon}

\item{\code{sq}}{Sequence}

\item{\code{dfln}}{Definition line}

\item{\code{ml_typ}}{Molecule type, e.g. DNA}

\item{\code{rec_typ}}{Record type: Whole or feature}

\item{\code{nncltds}}{Number of nucleotides}

\item{\code{nambgs}}{Number of ambiguous nucleotides}

\item{\code{pambgs}}{Proportion of ambiguous nucleotides}

\item{\code{gcr}}{GC ratio}

\item{\code{age}}{Number of days between sequence upload and running pipeline}
}}

\examples{
data('aotus')
seqrec <- aotus@sqs@sqs[[1]]
# this is a SeqRec object
# it contains sequence records
show(seqrec)
# you can access its different data slots with @
seqrec@id       # sequence ID, accession + feature location
seqrec@nm       # feature name, '' if none
seqrec@accssn   # accession
seqrec@vrsn     # accession version
seqrec@url      # NCBI GenBank URL
seqrec@txid     # Taxonomic ID
seqrec@orgnsm   # free-text organism name
seqrec@sq       # sequence, in raw format
seqrec@dfln     # sequence definition
seqrec@ml_typ   # molecule type
seqrec@rec_typ  # whole record or feature
seqrec@nncltds  # sequence length
seqrec@nambgs   # number of non-ATCGs
seqrec@pambgs   # proportion of non-ATCGs
seqrec@gcr      # GC-ratio
seqrec@age      # days since being added to GenBank
# get the sequence like so....
(rawToChar(seqrec@sq))
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{TaxDict-class}}, \code{\link{TaxRec-class}},
  \code{\link{clusters2_run}}, \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
