% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylosem.R
\name{phylosem_control}
\alias{phylosem_control}
\title{Detailed control for phylosem structure}
\usage{
phylosem_control(
  nlminb_loops = 1,
  newton_loops = 1,
  trace = 0,
  eval.max = 1000,
  iter.max = 1000,
  getsd = TRUE,
  quiet = FALSE,
  run_model = TRUE,
  getJointPrecision = FALSE
)
}
\arguments{
\item{nlminb_loops}{Integer number of times to call \code{\link[stats]{nlminb}}.}

\item{newton_loops}{Integer number of Newton steps to do after running
\code{\link[stats]{nlminb}}.}

\item{trace}{Parameter values are printed every `trace` iteration
for the outer optimizer. Passed to
`control` in \code{\link[stats]{nlminb}}.}

\item{eval.max}{Maximum number of evaluations of the objective function
allowed. Passed to `control` in \code{\link[stats]{nlminb}}.}

\item{iter.max}{Maximum number of iterations allowed. Passed to `control` in
\code{\link[stats]{nlminb}}.}

\item{getsd}{Boolean indicating whether to call \code{\link[TMB]{sdreport}}}

\item{quiet}{Boolean indicating whether to run model printing messages to terminal or not;}

\item{run_model}{Boolean indicating whether to estimate parameters (the default), or
instead to return the model inputs and compiled TMB object without running;}

\item{getJointPrecision}{whether to get the joint precision matrix.  Passed
to \code{\link[TMB]{sdreport}}.}
}
\value{
An S3 object of class "phylosem_control" that specifies detailed model settings,
allowing user specification while also specifying default values
}
\description{
Define a list of control parameters.  Note that
the format of this input is likely to change more rapidly than that of
\code{\link{phylosem}}
}
