% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Choropleth.R
\name{choropleth}
\alias{choropleth}
\title{Bin values}
\usage{
choropleth(x, k = 10, breaks = "quantile", min = NULL, max = NULL)
}
\arguments{
\item{x}{Vector of values to discretize.}

\item{k}{Numeric, the desired number of bins to discretize.}

\item{breaks}{one of \dQuote{equal}, \dQuote{pretty}, \dQuote{jenks},
\dQuote{quantile} or numeric vector with the actual breaks by
specifying the minimum (\code{min}) and maximum (\code{max}) bounds.}

\item{min}{the minima of the lowest bound of the break.}

\item{max}{the maxima of the upper bound of the break}
}
\value{
a vector with the discretized values.
}
\description{
\code{choropleth} discretizes the values of a quantity for mapping.
}
\examples{
library(sp)
s <- readRDS(system.file("nigeria/SR_Naija.rds", package = "phyloregion"))
k <- 10
COLOUR <- hcl.colors(k, "RdYlBu")
y <- choropleth(s$SR, k)

plot(s$SR, y)
## To plot and color according to some metric:
plot(s, col = COLOUR[y])
}
\seealso{
\code{\link{coldspots}}
}
\author{
Barnabas H. Daru \email{darunabas@gmail.com}
}
\keyword{bioregion}
