% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{read.community}
\alias{read.community}
\title{Read in sparse community matrices}
\usage{
read.community(file, grids = "grids", species = "species", ...)
}
\arguments{
\item{file}{A file name.}

\item{grids}{Column name of the column containing grid cells.}

\item{species}{Column name of the column containing the species / taxa names.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{read.community} returns a sparse matrix (an object of class
"dgCMatrix").
}
\description{
\code{read.community} reads in file containing occurrence data and returns a
sparse matrix.
}
\examples{
\donttest{
df <- data.frame(grids=paste0("g", c(1,1,2,3,3)),
                 species = paste0("sp", c(1,3,2,1,4)))
df
tmp <- tempfile()
write.csv(df, tmp)
(M <- read.community(tmp) )
sparse2long(M)
unlink(tmp)
}
}
\keyword{cluster}
