% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast.ed.ses.R
\name{rast.ed.ses}
\alias{rast.ed.ses}
\title{Evolutionary distinctiveness standardized for specie richness}
\usage{
rast.ed.ses(
  x,
  tree,
  edge.path,
  branch.length,
  n.descen,
  spat_alg = "bootspat_str",
  spat_alg_args = list(rprob = NULL, rich = NULL, fr_prob = NULL),
  random = c("tip", "spat")[2],
  aleats = 10,
  filename = "",
  ...
)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{tree}{phylo. A dated tree.}

\item{edge.path}{matrix representing the paths through the tree from root
to each tip. See \code{\link{phylo.pres}}}

\item{branch.length}{numeric. A Named numeric vector of branch length for
each species. See \code{\link{phylo.pres}}}

\item{n.descen}{numeric. A Named numeric vector of number of descendants for
each branch. See \code{\link{phylo.pres}}}

\item{spat_alg}{A function with the algorithm implementing the desired
randomization method. It must work with SpatRaster objects. See examples.
Example of functions that work are: \code{\link[SESraster]{bootspat_naive}},
\code{\link[SESraster]{bootspat_str}}, \code{\link[SESraster]{bootspat_ff}}.}

\item{spat_alg_args}{List of arguments passed to the randomization method
chosen in 'spat_alg'. See \code{\link[SESraster]{bootspat_naive}}, \code{\link[SESraster]{bootspat_str}},
\code{\link[SESraster]{bootspat_ff}}}

\item{random}{character. A character indicating the type of randomization.
The currently available randomization methods are "tip", "site", "species" or
"both" (site and species).}

\item{aleats}{positive integer. A positive integer indicating how many times
the calculation should be repeated.}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
Calculates the standardized effect size for evolutionary
distinctiveness. See Details for more information.
}
\details{
The spatial randomization (spat) keeps the
richness exact and samples
species presences proportionally to their
observed frequency (i.e. number
of occupied pixels). The randomization will
not assign values to cells with
nodata. The phylogenetic randomization shuffles
taxa names across all taxa
included in phylogeny.
}
\examples{
\donttest{
library(phyloraster)
library(SESraster)
x <- terra::rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))
t <- rast.ed.ses(x[[1:10]], tree, aleats = 3, random = "spat")
terra::plot(t)
}
}
\references{
Isaac, N. J., Turvey, S. T., Collen, B., Waterman, C. and
Baillie,
J. E. (2007). Mammals on the EDGE: conservation priorities based on threat
and phylogeny. PLoS ONE 2, e296.

Laffan, S. W., Rosauer, D. F., Di Virgilio, G., Miller, J. T.,
González‐Orozco, C. E., Knerr, N., ... & Mishler, B. D. (2016).
Range‐weighted
metrics of species and phylogenetic turnover can better
resolve biogeographic
transition zones. Methods in Ecology and Evolution, 7(5), 580-588.
}
\seealso{
\code{\link{phylo.pres}},
\code{\link{inv.range}},
\code{\link{geo.phylo.ses}},
\code{\link{rast.ed.ses}},
\code{\link{rast.pd.ses}},
\code{\link{rast.we.ses}},
\code{\link{rast.pe.ses}},
\code{\link[SESraster]{bootspat_str}},
\code{\link[SESraster]{bootspat_naive}},
\code{\link[SESraster]{bootspat_ff}},
\code{\link[SESraster]{SESraster}}
}
\author{
Neander M. Heming and Gabriela Alves-Ferreira
}
