% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeEpiRecord.R
\name{makeEpiRecord}
\alias{makeEpiRecord}
\title{Simulate epidemiological record}
\usage{
makeEpiRecord(lambda, duration = 1, NumCases = 50)
}
\arguments{
\item{lambda}{a numeric vector specifying the time varying intensity lambda(t) which is passed to \code{\link{simNHP.fun}} to generate the non-homogeneous Poisson process.}

\item{duration}{the fixed duration of infection (default is 1)}

\item{NumCases}{the approximate number of infected cases (default is 50)}
}
\value{
A matrix with columns "Infectee", "Infector", "InfnTime" (infection time), "RecTime" (recovery time), "DoneFlag".
Suitable for using with \code{\link{getLabGenealogy}}
}
\description{
Create an epidemiological record of infectors and infectees with corresponding infection and recovery times
}
\examples{
myepirecord <- makeEpiRecord(c(1,2,3,4), duration=2, NumCases=100)

}
\author{
Caroline Colijn \email{c.colijn@imperial.ac.uk}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
\seealso{
\code{\link{getLabGenealogy}}
}

