% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_api.R
\name{search_api}
\alias{search_api}
\title{Search GitHub and build a script index data frame}
\usage{
search_api(file_ext = "yml",
  gh_api = "https://api.github.com/search/code",
  rp_name = "phuse-org/phuse-scripts",
  rep_url = "https://github.com/phuse-org/phuse-scripts",
  rep_dir = "tree/master",
  rep_base = "https://raw.githubusercontent.com/phuse-org/phuse-scripts/master",
  loc_base = "C:/myCodes/phuse-org/phuse-scripts", filename = NULL,
  search_for = NULL, size = NULL, path = NULL)
}
\arguments{
\item{file_ext}{file extension; default to 'yml'}

\item{gh_api}{GitHub API URL; default to 'https://api.github.com/search/code'}

\item{rp_name}{repository name; default to 'phuse-org/phuse-scripts'}

\item{rep_url}{a URL for a remote repository and default to
'https://github.com/phuse-org/phuse-scripts'}

\item{rep_dir}{rep dir for file name; default to 'tree/master'}

\item{rep_base}{a URL for repository base folder; default to
"https://github.com/phuse-org/phuse-scripts/raw/master"}

\item{loc_base}{a URL for repository base folder; default to
"C:/myCodes/phuse-org/phuse-scripts"}

\item{filename}{file names to be searched; default to null}

\item{search_for}{text or key word to be searched in the files; defualt to null.}

\item{size}{file size; default to null}

\item{path}{file path; default to null}
}
\value{
a list of YML files
}
\description{
Use GitHub search API to search for YML files in phuse-scripts
  repository and output the list.
}
\examples{
\dontrun{
  r1 <- search_api('yml')
}
}
\author{
Hanming Tu
}
