% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\name{phrSetOutputFileName}
\alias{phrSetOutputFileName}
\title{Set the name of the output file.}
\usage{
phrSetOutputFileName(filename)
}
\arguments{
\item{filename}{the name of the file.}
}
\description{
Sets the name of the output file. The default value is phreeqc.0.out.
}
\details{
The output file must be turned on using the \code{\link{phrSetOutputFileOn}} function.
}
\examples{

# This example equilibrates pure water with calcite and displays
# the resulting file name.
phrLoadDatabaseString(phreeqc.dat)
phrSetOutputFileOn(TRUE)
phrSetOutputFileName(file.path(tempdir(), "calcite.out"))
input <- c( 
  'SOLUTION 1 Pure water ',
  'EQUILIBRIUM_PHASES 1  ',
  '    Calcite 0 10      '
  )

if (is.null(phrRunString(input))) {
  cat(paste("see ", phrGetOutputFileName(), ".\n", sep = ""))
}

}
\references{
\url{https://water.usgs.gov/water-resources/software/PHREEQC/IPhreeqc.pdf}
}
\seealso{
Other Output: 
\code{\link{phrGetOutputFileName}()},
\code{\link{phrGetOutputFileOn}()},
\code{\link{phrGetOutputStringsOn}()},
\code{\link{phrGetOutputStrings}()},
\code{\link{phrSetOutputFileOn}()},
\code{\link{phrSetOutputStringsOn}()}
}
\concept{Output}
